/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.PixelImage;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.TreeRow;
import ibm.nways.jdm.Watchable;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import mlsoft.mct.MlTree;

class FolderRow
extends TreeRow {
    private Image image;
    private MemoryImageSource memSource;
    private boolean isOpen = true;
    private PixelImage[] currImages = openPixelImages;
    private int statusInt;
    private int currWidth = openImageWidth;
    private static Image baseStatusFolderClosedImage;
    private static PixelImage[] closedPixelImages;
    private static int closedImageWidth;
    private static int closedImageHeight;
    private static Image baseStatusFolderOpenImage;
    private static PixelImage[] openPixelImages;
    private static int openImageWidth;
    private static int openImageHeight;
    private static BrowserApplet browserApp;

    public FolderRow(MlTree mlTree, NavigationPoint navigationPoint) {
        super(mlTree, navigationPoint);
        this.isOpen = ((NavigationFolder)navigationPoint).getIsInitiallyExpanded();
        Status status = navigationPoint.getStatus();
        if (status != null) {
            this.setOpenClosedVals();
            this.statusInt = status.getStatusType().toInt();
            PixelImage pixelImage = this.currImages[this.statusInt];
            if (pixelImage == null) {
                if (this.isOpen) {
                    FolderRow.openPixelImages[this.statusInt] = pixelImage = TreeRow.initPixelImage(baseStatusFolderOpenImage, mlTree, this.statusInt);
                } else {
                    FolderRow.closedPixelImages[this.statusInt] = pixelImage = TreeRow.initPixelImage(baseStatusFolderClosedImage, mlTree, this.statusInt);
                }
            }
            this.memSource = new MemoryImageSource(openImageWidth, openImageHeight, pixelImage.pixels, 0, openImageWidth);
            this.image = Toolkit.getDefaultToolkit().createImage(this.memSource);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void update(Watchable watchable, Object object) {
        if (this.image != null) {
            this.statusInt = ((Status)watchable).getStatusType().toInt();
            this.update();
        }
    }

    public void update() {
        if (this.image != null) {
            PixelImage pixelImage = this.currImages[this.statusInt];
            if (pixelImage == null) {
                if (this.isOpen) {
                    FolderRow.openPixelImages[this.statusInt] = pixelImage = TreeRow.initPixelImage(baseStatusFolderOpenImage, this.tree, this.statusInt);
                } else {
                    FolderRow.closedPixelImages[this.statusInt] = pixelImage = TreeRow.initPixelImage(baseStatusFolderClosedImage, this.tree, this.statusInt);
                }
            }
            this.memSource.newPixels(this.currImages[this.statusInt].pixels, ColorModel.getRGBdefault(), 0, this.currWidth);
            this.image.flush();
            this.tree.repaint();
        }
    }

    public static void initImages(BrowserApplet browserApplet) {
        baseStatusFolderClosedImage = browserApplet.imageFrom(browserApplet, "/ibm/nways/jdm/StatusFolderClosed.gif");
        closedImageHeight = baseStatusFolderClosedImage.getHeight(browserApplet);
        closedImageWidth = baseStatusFolderClosedImage.getWidth(browserApplet);
        closedPixelImages = new PixelImage[StatusType.NumDefined];
        baseStatusFolderOpenImage = browserApplet.imageFrom(browserApplet, "/ibm/nways/jdm/StatusFolderOpen.gif");
        openImageHeight = baseStatusFolderOpenImage.getHeight(browserApplet);
        openImageWidth = baseStatusFolderOpenImage.getWidth(browserApplet);
        openPixelImages = new PixelImage[StatusType.NumDefined];
        browserApp = browserApplet;
    }

    public void openFolder() {
        this.isOpen = true;
        this.setOpenClosedVals();
    }

    public void closeFolder() {
        this.isOpen = false;
        this.setOpenClosedVals();
    }

    private void setOpenClosedVals() {
        if (this.isOpen) {
            this.currImages = openPixelImages;
            this.currWidth = openImageWidth;
            return;
        }
        this.currImages = closedPixelImages;
        this.currWidth = closedImageWidth;
    }
}

